<?php
require_once 'config.php';
require_once 'header.php';

// Redirect if not logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_feedback'])) {
    $subject = trim($_POST['subject'] ?? '');
    $message = trim($_POST['message'] ?? '');
    $rating = $_POST['rating'] ?? '';

    if (empty($subject) || empty($message) || empty($rating)) {
        $error = 'All fields are required.';
    } elseif (!is_numeric($rating) || $rating < 1 || $rating > 5) {
        $error = 'Rating must be a number between 1 and 5.';
    } else {
        $stmt = $pdo->prepare("INSERT INTO feedback (user_id, subject, message, rating) VALUES (?, ?, ?, ?)");
        if ($stmt->execute([$user_id, $subject, $message, $rating])) {
            $success = 'Feedback submitted successfully. Thank you!';
        } else {
            $error = 'Submission failed. Please try again.';
        }
    }
}

// Fetch user's feedback entries
$stmt = $pdo->prepare("SELECT * FROM feedback WHERE user_id = ? ORDER BY created_at DESC");
$stmt->execute([$user_id]);
$feedbacks = $stmt->fetchAll();
?>

<h2>Welcome, <?= htmlspecialchars($_SESSION['user_name']) ?></h2>

<h3>Submit Your Feedback</h3>
<?php if (isset($error)): ?><p class="error"><?= htmlspecialchars($error) ?></p><?php endif; ?>
<?php if (isset($success)): ?><p class="success"><?= htmlspecialchars($success) ?></p><?php endif; ?>

<form method="post">
    <label for="subject">Subject:</label>
    <input type="text" name="subject" id="subject" required value="<?= htmlspecialchars($_POST['subject'] ?? '') ?>">

    <label for="message">Your Feedback:</label>
    <textarea name="message" id="message" rows="5" required><?= htmlspecialchars($_POST['message'] ?? '') ?></textarea>

    <label for="rating">Rating (1-5):</label>
    <input type="number" name="rating" id="rating" min="1" max="5" required value="<?= htmlspecialchars($_POST['rating'] ?? '') ?>">

    <button type="submit" name="submit_feedback">Submit Feedback</button>
</form>

<h3>Your Past Feedback</h3>
<?php if (count($feedbacks) > 0): ?>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Subject</th>
                <th>Rating</th>
                <th>Status</th>
                <th>Submitted On</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($feedbacks as $fb): ?>
            <tr>
                <td><?= $fb['id'] ?></td>
                <td><?= htmlspecialchars($fb['subject']) ?></td>
                <td><?= $fb['rating'] ?> / 5</td>
                <td><?= ucfirst($fb['status']) ?></td>
                <td><?= date('d M Y, h:i A', strtotime($fb['created_at'])) ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>You haven't submitted any feedback yet.</p>
<?php endif; ?>

<?php require_once 'footer.php'; ?>